;; -*- lexical-binding: t; -*-

(TeX-add-style-hook
 "main"
 (lambda ()
   (setq TeX-command-extra-options
         "-shell-escape")
   (TeX-add-to-alist 'LaTeX-provided-class-options
                     '(("tau-class/tau" "9pt" "a4paper" "twocolumn" "twoside")))
   (TeX-add-to-alist 'LaTeX-provided-package-options
                     '(("babel" "english") ("biblatex" "	backend=biber" "	style=ieee" "	sorting=ynt")))
   (add-to-list 'LaTeX-verbatim-macros-with-braces-local "url")
   (add-to-list 'LaTeX-verbatim-macros-with-braces-local "path")
   (add-to-list 'LaTeX-verbatim-macros-with-delims-local "url")
   (add-to-list 'LaTeX-verbatim-macros-with-delims-local "path")
   (TeX-run-style-hooks
    "latex2e"
    "tau-class/tau"
    "tau-class/tau10"
    "babel"
    "biblatex")
   (TeX-add-symbols
    "titlepos")
   (LaTeX-add-labels
    "tab:table"
    "fig:figure"
    "fig:figa"
    "fig:figb"
    "fig:examplefloat"
    "ec:equation")
   (LaTeX-add-bibliographies
    "tau")
   (LaTeX-add-lengths
    "eqskip"))
 :latex)

